/**
 * @namespace 共通処理
 */
var neo = {};

/**
 * @namespace 共通: 言語別リソース
 */
neo.Resource = {
    code : "en_US",
    codeCkeditor: "en"
};

/**
 * 各種HTTPエラー
 */
neo.Resource.ajax = {
    "400_errorMessage" : "W:This process has been done or is doing with wrong procedure. Stop the process and try again.",
    "403_errorMessage" : "W:Cannot access the requested process.<br/>The permissions might have been changed or the session has expired. Please abort the process and try again.",
    "404_errorMessage" : "The URL might not be valid.",
    "408_errorMessage" : "W:Database server is busy. Please wait awhile and try again later.",
    "409_errorMessage" : "An error has occurred in the server. Database is down or you have no access to the specified area. Please contact your system administrator.",
    "500_errorMessage" : "An error has occurred in the server. Please contact your system administrator.",
    "503_errorMessage" : "W:Server is busy. Please wait awhile and try again later.",
    "504_errorMessage" : "Connection to the server timed out.",
    "errorMessage" : "The server is down or the network is busy."
};

/**
 * 日付の書式
 */
neo.Resource.dateTime = {
    // 短い月の名前
    "shortMonthes": ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
    // 長い月の名前
    "longMonthes": ["January","February","March","April","May","June","July","August","September","October","November","December"],
    // 短い週の名前(日曜日から)
    "shortWeeks": ["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],
    // 長い週の名前(日曜日から)
    "longWeeks": ["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],
    // 午前/午後
    "periods": ["AM","PM"],
    // 経過時間
    "passedTime": {"second": "_ seconds ago", "minute": "_ minutes ago", "hour": "_ hour(s) ago", "day": "_ day(s) ago", "month": "_ month(s) ago", "year": "_ year(s) ago"},
    "passedShortTime": {"second": "_ seconds", "minute": "_ minutes", "hour": "_ hour(s)", "day": "_ day(s)", "month": "_ month(s)", "year": "_ year(s)"}
};

/**
 * ダイアログ文言
 */
neo.Resource.dialog = {
    "closeLabel": "Close", // タイトルバーの×ボタン
    "alertTitle": "Alert",
    "confirmTitle": "Confirm",
    "alertButtonLabel": "Close", // メッセージ系ダイアログのボタン
    "confirmYesButtonLabel": "Yes", // 確認ダイアログの肯定ボタン
    "confirmNoButtonLabel": "No", // 確認ダイアログの否定ボタン
    "actionOkButtonLabel": "OK", // 選択/設定ダイアログの肯定ボタン
    "actionCancelButtonLabel": "Cancel" // 選択/設定ダイアログの否定ボタン
};